<?php
require_once '../config/db.php';
$settings = [];
$stmt = $pdo->query('SELECT key_name, value FROM settings');
foreach ($stmt as $row) {
    $settings[$row['key_name']] = $row['value'];
}
// جلب بيانات المشروع
$id = intval($_GET['id'] ?? 0);
$stmt = $pdo->prepare('SELECT * FROM projects WHERE id = ?');
$stmt->execute([$id]);
$project = $stmt->fetch();
if (!$project) {
    echo '<h2>المشروع غير موجود</h2>';
    exit;
}
// جلب نماذج الوحدات
$units = $pdo->prepare('SELECT * FROM unit_models WHERE project_id = ?');
$units->execute([$id]);
$units = $units->fetchAll();
// جلب الصور والفيديوهات
$media = $pdo->prepare('SELECT * FROM media WHERE project_id = ?');
$media->execute([$id]);
$media = $media->fetchAll();
// جلب الأماكن القريبة
$places = $pdo->prepare('SELECT * FROM nearby_places WHERE project_id = ?');
$places->execute([$id]);
$places = $places->fetchAll();
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تفاصيل المشروع - <?= htmlspecialchars($project['name']) ?></title>
    <link rel="stylesheet" href="../public/style.css">
    <style>
        body { background: <?= $settings['bg_color'] ?? '#EEEEEE' ?>; font-family: 'Cairo', sans-serif; }
        .navbar { background: <?= $settings['main_color'] ?? '#EA9218' ?>; color: #fff; padding: 12px 0; display: flex; align-items: center; justify-content: space-between; }
        .navbar img { height: 48px; margin-right: 16px; }
        .navbar ul { list-style: none; display: flex; gap: 24px; margin: 0; padding: 0; }
        .navbar li { display: inline; }
        .navbar a { color: #fff; text-decoration: none; font-weight: bold; font-size: 18px; }
        .container { max-width: 1100px; margin: 32px auto; background: #fff; border-radius: 8px; box-shadow: 0 0 10px #31384122; padding: 32px; }
        .project-title { color: <?= $settings['main_color'] ?? '#EA9218' ?>; font-size: 28px; margin-bottom: 16px; text-align: center; }
        .project-info { display: flex; flex-wrap: wrap; gap: 32px; margin-bottom: 32px; justify-content: center; }
        .info-card { background: #EEEEEE; border-radius: 8px; padding: 16px; min-width: 180px; text-align: center; color: #3A4750; }
        .desc { margin-bottom: 24px; color: #313841; font-size: 18px; text-align: center; }
        .media-gallery { display: flex; gap: 16px; flex-wrap: wrap; justify-content: center; margin-bottom: 32px; }
        .media-thumb { max-width: 180px; max-height: 120px; border-radius: 6px; }
        .units-title { color: #EA9218; font-size: 22px; margin-bottom: 16px; text-align: center; }
        .unit-cards { display: flex; flex-wrap: wrap; gap: 24px; justify-content: center; margin-bottom: 32px; }
        .unit-card { background: #fff; border-radius: 8px; box-shadow: 0 0 8px #31384122; padding: 16px; min-width: 200px; max-width: 260px; text-align: center; }
        .unit-card h4 { color: #3A4750; margin-bottom: 8px; }
        .unit-card .price { color: #EA9218; font-size: 16px; margin-bottom: 8px; }
        .unit-card .area { color: #313841; font-size: 15px; margin-bottom: 8px; }
        .unit-card .features { color: #3A4750; font-size: 14px; margin-bottom: 8px; }
        .places-title { color: #EA9218; font-size: 20px; margin-bottom: 12px; text-align: center; }
        .places-cards { display: flex; flex-wrap: wrap; gap: 16px; justify-content: center; margin-bottom: 32px; }
        .place-card { background: #EEEEEE; border-radius: 8px; padding: 12px; min-width: 140px; text-align: center; color: #3A4750; font-size: 15px; }
        .map-section { text-align: center; margin-bottom: 32px; }
        .brochure { margin-bottom: 16px; text-align: center; }
        .contact-form label { color: #3A4750; font-weight: bold; }
        .contact-form input, .contact-form textarea { width: 100%; padding: 8px; margin-bottom: 12px; border: 1px solid #EA9218; border-radius: 4px; }
        .contact-form button { background: #EA9218; color: #fff; border: none; padding: 10px 24px; border-radius: 4px; width: 100%; font-size: 16px; }
        .footer { background: <?= $settings['secondary_color'] ?? '#3A4750' ?>; color: #fff; padding: 24px 0; text-align: center; margin-top: 48px; }
        .footer img { height: 40px; margin-bottom: 8px; }
    </style>
</head>
<body>
    <!-- النافبار -->
    <nav class="navbar">
        <div>
            <img src="../assets/<?= htmlspecialchars($settings['logo'] ?? 'logo.png') ?>" alt="شعار الشركة">
        </div>
        <ul>
            <li><a href="index.php">الرئيسية</a></li>
            <li><a href="projects.php">المشاريع</a></li>
            <li><a href="about.php">من نحن</a></li>
            <li><a href="contact.php">تواصل معنا</a></li>
            <li><a href="#" onclick="alert('قريباً!');">تغيير اللغة</a></li>
        </ul>
    </nav>
    <div class="container">
        <div class="project-title"> <?= htmlspecialchars($project['name']) ?> </div>
        <div class="project-info">
            <div class="info-card">السعر: <?= $project['price_from'] ?> - <?= $project['price_to'] ?> ريال</div>
            <div class="info-card">المنطقة: <?= htmlspecialchars($project['location']) ?></div>
            <div class="info-card">عدد الوحدات: <?= $project['units_count'] ?></div>
            <div class="info-card">المساحة: <?= $project['area'] ?> م²</div>
            <div class="info-card">الحالة: <?= $project['status'] ?></div>
            <?php if (!empty($project['brochure'])): ?>
                <div class="info-card brochure"><a href="../uploads/<?= htmlspecialchars($project['brochure']) ?>" target="_blank">تحميل كتيب المشروع</a></div>
            <?php endif; ?>
        </div>
        <div class="desc"> <?= nl2br(htmlspecialchars($project['description'])) ?> </div>
        <!-- معرض الصور والفيديوهات -->
        <div class="media-gallery">
            <?php foreach ($media as $m): ?>
                <?php if ($m['type']=='image'): ?>
                    <img src="../uploads/<?= htmlspecialchars($m['file_path']) ?>" class="media-thumb" alt="صورة المشروع">
                <?php else: ?>
                    <video src="../uploads/<?= htmlspecialchars($m['file_path']) ?>" class="media-thumb" controls></video>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
        <!-- نماذج الوحدات -->
        <div class="units-title">نماذج الوحدات</div>
        <div class="unit-cards">
            <?php foreach ($units as $unit): ?>
            <div class="unit-card">
                <h4><?= htmlspecialchars($unit['name']) ?></h4>
                <div class="area">المساحة: <?= $unit['area'] ?> م²</div>
                <div class="price">السعر: <?= $unit['price'] ?> ريال</div>
                <div class="features">غرف النوم: <?= $unit['bedrooms'] ?> | دورات المياه: <?= $unit['bathrooms'] ?></div>
                <div class="features">المميزات: <?= nl2br(htmlspecialchars($unit['features'])) ?></div>
            </div>
            <?php endforeach; ?>
        </div>
        <!-- الأماكن القريبة -->
        <div class="places-title">الأماكن القريبة</div>
        <div class="places-cards">
            <?php foreach ($places as $place): ?>
            <div class="place-card">
                <div><?= $place['place_type'] ?>: <?= htmlspecialchars($place['name']) ?></div>
                <div><a href="<?= htmlspecialchars($place['map_url']) ?>" target="_blank">رابط الموقع</a></div>
                <div>المسافة: <?= $place['distance_km'] ?> كم</div>
            </div>
            <?php endforeach; ?>
        </div>
        <!-- خريطة الموقع (Google Maps) -->
        <div class="map-section">
            <?php if (!empty($project['location'])): ?>
                <iframe src="https://www.google.com/maps?q=<?= urlencode($project['location']) ?>&output=embed" width="100%" height="300" style="border:0;border-radius:8px;" allowfullscreen="" loading="lazy"></iframe>
            <?php endif; ?>
        </div>
        <!-- نموذج استفسار عن المشروع -->
        <form class="contact-form" method="post" action="contact.php">
            <input type="hidden" name="project_id" value="<?= $project['id'] ?>">
            <label>الاسم</label>
            <input type="text" name="name" required>
            <label>البريد الإلكتروني</label>
            <input type="email" name="email" required>
            <label>الهاتف</label>
            <input type="text" name="phone" required>
            <label>استفسارك عن المشروع</label>
            <textarea name="message" rows="3" required></textarea>
            <button type="submit">إرسال الاستفسار</button>
        </form>
    </div>
    <!-- الفوتر -->
    <footer class="footer">
        <?php if (!empty($settings['logo'])): ?>
            <img src="../assets/<?= htmlspecialchars($settings['logo']) ?>" alt="شعار الشركة">
        <?php endif; ?>
        <div><?= htmlspecialchars($settings['company_name'] ?? 'شركتنا العقارية') ?></div>
        <div>جميع الحقوق محفوظة &copy; <?= date('Y') ?></div>
    </footer>
</body>
</html>
